import UIKit

class ViewController: UIViewController
{
    @IBOutlet weak var redBox: UIView!

    override func touchesEnded(_ touches: Set<UITouch>,
                               with event: UIEvent?)
    {
        redBox.layer.shadowOffset = CGSize(width: -10.0,
                                           height: 20.0)
        redBox.layer.shadowOpacity = 0.75
        
        CATransaction.begin()
        CATransaction.setAnimationDuration(2.0)
        CATransaction.setAnimationTimingFunction(CAMediaTimingFunction(name: CAMediaTimingFunctionName.easeInEaseOut))
        
        UIView.animate(withDuration: 2.0)
        {
            self.redBox.center = self.view.center
        }
        
        let cornerAnim = CABasicAnimation (keyPath: nil)
        cornerAnim.fromValue = 0.0
        cornerAnim.toValue = 50.0
        redBox.layer.cornerRadius = 50.0
        redBox.layer.add(cornerAnim, forKey: #keyPath(CALayer.cornerRadius))
        
        
        let shadowColAnim = CABasicAnimation (keyPath: #keyPath(CALayer.shadowColor))
        shadowColAnim.fromValue = UIColor.black.cgColor
        shadowColAnim.toValue = UIColor.green.cgColor
        redBox.layer.shadowColor = UIColor.green.cgColor
        redBox.layer.add(shadowColAnim, forKey: nil)
        
        CATransaction.commit()
    }
    

}

